/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.error.InvalidManifestException;
import com.artipie.docker.error.InvalidRepoNameException;
import com.artipie.docker.error.InvalidTagNameException;
import com.artipie.docker.http.ErrorsResponse;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rs.RsStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;

final class ErrorHandlingSlice
implements Slice {
    private final Slice origin;

    ErrorHandlingSlice(Slice origin) {
        this.origin = origin;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Response response;
        try {
            Response original = this.origin.response(line, headers, body);
            response = connection -> {
                CompletionStage sent;
                try {
                    sent = original.send(connection);
                }
                catch (RuntimeException ex) {
                    sent = ErrorHandlingSlice.handle(ex).map(rsp -> rsp.send(connection)).orElseThrow(() -> ex);
                }
                return sent.handle((nothing, throwable) -> {
                    CompletionStage<Void> result = throwable == null ? CompletableFuture.completedFuture(nothing) : ErrorHandlingSlice.handle(throwable).map(rsp -> rsp.send(connection)).orElseGet(() -> CompletableFuture.failedFuture(throwable));
                    return result;
                }).thenCompose(Function.identity());
            };
        }
        catch (RuntimeException ex) {
            response = ErrorHandlingSlice.handle(ex).orElseThrow(() -> ex);
        }
        return response;
    }

    private static Optional<Response> handle(Throwable throwable) {
        if (throwable instanceof InvalidRepoNameException) {
            return Optional.of(new ErrorsResponse(RsStatus.BAD_REQUEST, (InvalidRepoNameException)throwable));
        }
        if (throwable instanceof InvalidTagNameException) {
            return Optional.of(new ErrorsResponse(RsStatus.BAD_REQUEST, (InvalidTagNameException)throwable));
        }
        if (throwable instanceof InvalidManifestException) {
            return Optional.of(new ErrorsResponse(RsStatus.BAD_REQUEST, (InvalidManifestException)throwable));
        }
        return Optional.empty();
    }
}

