/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TrimmedDocker
implements Docker {
    private final Docker origin;
    private final Pattern prefix;

    public TrimmedDocker(Docker origin, String prefix) {
        this(origin, Pattern.compile(String.format("(?:%s)\\/(.+)", prefix)));
    }

    public TrimmedDocker(Docker origin, Pattern prefix) {
        this.origin = origin;
        this.prefix = prefix;
    }

    @Override
    public Repo repo(RepoName name) {
        Matcher matcher = this.prefix.matcher(name.value());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid image name: name `%s` must match `%s`", name.value(), this.prefix.pattern()));
        }
        return this.origin.repo(new RepoName.Valid(matcher.group(1)));
    }
}

