/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.RepoName;
import com.artipie.docker.Upload;
import com.artipie.docker.asto.UploadKey;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class AstoUpload
implements Upload {
    private final Storage storage;
    private final RepoName name;
    private final String uuid;

    public AstoUpload(Storage storage, RepoName name, String uuid) {
        this.storage = storage;
        this.name = name;
        this.uuid = uuid;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public CompletionStage<Void> start() {
        return this.storage.save(this.data(), (Content)new Content.From(new byte[0]));
    }

    @Override
    public CompletionStage<Long> append(Publisher<ByteBuffer> chunk) {
        return this.storage.size(this.data()).thenCompose(size -> {
            if (size > 0L) {
                throw new UnsupportedOperationException("Multiple chunks are not supported");
            }
            return this.storage.save(this.data(), (Content)new Content.From(chunk)).thenCompose(ignored -> this.storage.size(this.data()).thenApply(updated -> updated - 1L));
        });
    }

    @Override
    public CompletionStage<Content> content() {
        return this.storage.value(this.data());
    }

    @Override
    public CompletionStage<Long> offset() {
        return this.storage.size(this.data()).thenApply(size -> Math.max(size - 1L, 0L));
    }

    @Override
    public CompletionStage<Void> delete() {
        return this.storage.list(this.root()).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(file -> this.storage.delete(file).toCompletableFuture()).toArray(CompletableFuture[]::new)));
    }

    Key root() {
        return new UploadKey(this.name, this.uuid);
    }

    private Key data() {
        return new Key.From(this.root(), new String[]{"data"});
    }
}

