/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.docker.misc.ByteBufPublisher;
import com.artipie.docker.proxy.ClientSlices;
import com.artipie.docker.proxy.Credentials;
import com.artipie.docker.proxy.TokenResponse;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Authorization;
import com.artipie.http.headers.WwwAuthenticate;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class AuthClientSlice
implements Slice {
    private final ClientSlices client;
    private final Slice origin;
    private final Credentials credentials;

    public AuthClientSlice(ClientSlices client, Slice origin) {
        this(client, origin, Credentials.ANONYMOUS);
    }

    public AuthClientSlice(ClientSlices client, Slice origin, Credentials credentials) {
        this.client = client;
        this.origin = origin;
        this.credentials = credentials;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        CompletableFuture promise = new CompletableFuture();
        return new AsyncResponse(this.origin.response(line, headers, body).send((rsstatus, rsheaders, rsbody) -> {
            RsFull original = new RsFull(rsstatus, (Iterable)rsheaders, rsbody);
            Object response = rsstatus == RsStatus.UNAUTHORIZED ? new AsyncResponse(this.authenticate(new WwwAuthenticate(rsheaders)).thenApply(authorization -> this.origin.response(line, (Iterable)new Headers.From(headers, authorization), body))) : original;
            promise.complete(response);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }).thenCompose(nothing -> promise));
    }

    private CompletionStage<Map.Entry<String, String>> authenticate(WwwAuthenticate header) {
        URI realm;
        String scheme = header.scheme();
        if (!scheme.equals("Bearer")) {
            throw new IllegalArgumentException(String.format("Unsupported authentication scheme: %s", scheme));
        }
        try {
            realm = new URI(header.realm());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String path = realm.getPath();
        String query = header.params().stream().filter(param -> !param.name().equals("realm")).map(param -> String.format("%s=%s", param.name(), param.value())).collect(Collectors.joining("&"));
        CompletableFuture promise = new CompletableFuture();
        return this.client.slice(realm.getHost()).response(new RequestLine(RqMethod.GET, String.format("%s?%s", path, query)).toString(), (Iterable<Map.Entry<String, String>>)this.credentials.headers(), (Publisher<ByteBuffer>)Flowable.empty()).send((status, headers, body) -> new ByteBufPublisher((Publisher<ByteBuffer>)body).bytes().thenApply(TokenResponse::new).thenApply(TokenResponse::token).thenCompose(token -> {
            promise.complete(token);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        })).thenCompose(ignored -> promise).thenApply(Authorization.Bearer::new);
    }
}

