/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.Digests;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.asto.AstoBlob;
import com.artipie.docker.asto.BlobKey;
import com.artipie.docker.asto.BlobStore;
import io.reactivex.Flowable;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cactoos.Bytes;
import org.cactoos.io.BytesOf;
import org.cactoos.text.HexOf;
import org.reactivestreams.Publisher;

public final class AstoBlobs
implements BlobStore {
    private final Storage asto;

    public AstoBlobs(Storage asto) {
        this.asto = asto;
    }

    @Override
    public CompletionStage<Optional<Blob>> blob(Digest digest) {
        return this.asto.exists((Key)new BlobKey(digest)).thenApply(exists -> {
            Optional<Object> blob = exists != false ? Optional.of(new AstoBlob(this.asto, digest)) : Optional.empty();
            return blob;
        });
    }

    @Override
    public CompletionStage<Blob> put(Content blob, Digest digest) {
        MessageDigest sha = Digests.SHA256.get();
        Flowable checked = Flowable.fromPublisher((Publisher)blob).map(buf -> {
            sha.update(new Remaining(buf, true).bytes());
            return buf;
        }).doOnTerminate(() -> {
            String calculated = new HexOf((Bytes)new BytesOf(sha.digest())).asString();
            if (!digest.hex().equals(calculated)) {
                throw new IllegalArgumentException("Digests differ");
            }
        });
        BlobKey key = new BlobKey(digest);
        return ((CompletableFuture)this.asto.exists((Key)key).thenCompose(arg_0 -> this.lambda$put$3(key, blob, (Publisher)checked, arg_0))).thenApply(nothing -> new AstoBlob(this.asto, digest));
    }

    private /* synthetic */ CompletionStage lambda$put$3(BlobKey key, Content blob, Publisher checked, Boolean exists) {
        CompletableFuture result = exists != false ? CompletableFuture.allOf(new CompletableFuture[0]) : this.asto.save((Key)key, (Content)new Content.From(blob.size(), checked));
        return result;
    }
}

