/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.asto.Content;
import com.artipie.docker.Digest;
import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.error.BlobUnknownError;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.http.ErrorsResponse;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class BlobEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/blobs/(?<digest>(?!(uploads/)).*)$");

    private BlobEntity() {
    }

    static final class Request {
        private final RqByRegex rqregex;

        Request(String line) {
            this.rqregex = new RqByRegex(line, PATH);
        }

        RepoName name() {
            return new RepoName.Valid(this.rqregex.path().group("name"));
        }

        Digest digest() {
            return new Digest.FromString(this.rqregex.path().group("digest"));
        }
    }

    private static class BaseResponse
    extends Response.Wrap {
        BaseResponse(Digest digest) {
            super((Response)new RsWithHeaders((Response)new RsWithStatus(RsStatus.OK), new Map.Entry[]{new DigestHeader(digest), new ContentType("application/octet-stream")}));
        }
    }

    static final class Head
    implements Slice {
        private final Docker docker;

        Head(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            Digest digest = request.digest();
            return new AsyncResponse(this.docker.repo(request.name()).layers().get(digest).thenApply(found -> found.map(blob -> new AsyncResponse(blob.size().thenApply(size -> new RsWithHeaders((Response)new BaseResponse(blob.digest()), new Map.Entry[]{new ContentLength(String.valueOf(size))})))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new BlobUnknownError(digest)))));
        }
    }

    static final class Get
    implements Slice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            Digest digest = request.digest();
            return new AsyncResponse(this.docker.repo(request.name()).layers().get(digest).thenApply(found -> found.map(blob -> new AsyncResponse(blob.content().thenCompose(content -> content.size().map(CompletableFuture::completedFuture).orElseGet(blob::size).thenApply(size -> new RsWithBody((Response)new BaseResponse(digest), (Content)new Content.From(size.longValue(), (Publisher)content)))))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new BlobUnknownError(digest)))));
        }
    }
}

