/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.error.DockerError;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

final class ErrorsResponse
extends Response.Wrap {
    protected ErrorsResponse(RsStatus status, DockerError ... errors) {
        this(status, Arrays.asList(errors));
    }

    protected ErrorsResponse(RsStatus status, Collection<DockerError> errors) {
        super((Response)new RsWithBody((Response)new RsWithStatus(status), (CharSequence)ErrorsResponse.json(errors), StandardCharsets.UTF_8));
    }

    private static String json(Collection<DockerError> errors) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (DockerError error : errors) {
            JsonObjectBuilder obj = Json.createObjectBuilder().add("code", error.code()).add("message", error.message());
            error.detail().ifPresent(detail -> obj.add("detail", detail));
            array.add(obj);
        }
        return Json.createObjectBuilder().add("errors", array).build().toString();
    }
}

