/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.docker.Digest;
import com.artipie.docker.Manifests;
import com.artipie.docker.RepoName;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.manifest.JsonManifest;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.proxy.ManifestPath;
import com.artipie.docker.ref.ManifestRef;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class ProxyManifests
implements Manifests {
    private final Slice remote;
    private final RepoName name;

    public ProxyManifests(Slice remote, RepoName name) {
        this.remote = remote;
        this.name = name;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        CompletableFuture promise = new CompletableFuture();
        return this.remote.response(new RequestLine(RqMethod.GET, new ManifestPath(this.name, ref).string()).toString(), (Iterable)Headers.EMPTY, (Publisher)Flowable.empty()).send((status, headers, body) -> {
            Object result;
            if (status == RsStatus.OK) {
                Digest digest = new DigestHeader(headers).value();
                result = new PublisherAs(body).bytes().thenApply(bytes -> Optional.of(new JsonManifest(digest, (byte[])bytes)));
            } else {
                result = status == RsStatus.NOT_FOUND ? CompletableFuture.completedFuture(Optional.empty()) : new FailedCompletionStage((Throwable)new IllegalArgumentException(String.format("Unexpected status: %s", status)));
            }
            return result.thenAccept(promise::complete).toCompletableFuture();
        }).thenCompose(nothing -> promise);
    }
}

