/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Digest;
import com.artipie.docker.asto.BlobSource;
import com.artipie.docker.asto.TrustedBlobSource;
import com.artipie.docker.error.InvalidDigestException;
import com.artipie.docker.misc.DigestedFlowable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class CheckedBlobSource
implements BlobSource {
    private final Content content;
    private final Digest dig;

    public CheckedBlobSource(Content content, Digest dig) {
        this.content = content;
        this.dig = dig;
    }

    @Override
    public Digest digest() {
        return this.dig;
    }

    @Override
    public CompletionStage<Void> saveTo(Storage storage, Key key) {
        DigestedFlowable digested = new DigestedFlowable((Publisher<ByteBuffer>)this.content);
        Content.From checked = new Content.From(this.content.size(), (Publisher)digested.doOnComplete(() -> {
            String calculated = digested.digest().hex();
            String expected = this.dig.hex();
            if (!expected.equals(calculated)) {
                throw new InvalidDigestException(String.format("calculated: %s expected: %s", calculated, expected));
            }
        }));
        return new TrustedBlobSource((Content)checked, this.dig).saveTo(storage, key);
    }
}

