/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.http.JsonContentType;
import com.artipie.docker.http.Scope;
import com.artipie.docker.http.ScopeSlice;
import com.artipie.docker.perms.DockerRegistryPermission;
import com.artipie.docker.perms.RegistryCategory;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqParams;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class CatalogEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/_catalog$");

    private CatalogEntity() {
    }

    public static class Get
    implements ScopeSlice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        @Override
        public DockerRegistryPermission permission(String line, String name) {
            return new DockerRegistryPermission(name, new Scope.Registry(RegistryCategory.CATALOG));
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            RqParams params = new RqParams(new RequestLineFrom(line).uri().getQuery());
            return new AsyncResponse(this.docker.catalog(params.value("last").map(RepoName.Simple::new), params.value("n").map(Integer::parseInt).orElse(Integer.MAX_VALUE)).thenApply(catalog -> new RsWithBody((Response)new RsWithHeaders((Response)new RsWithStatus(RsStatus.OK), new Map.Entry[]{new JsonContentType()}), catalog.json())));
        }
    }
}

