/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.asto.Content;
import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.error.ManifestError;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.http.DockerAuthSlice;
import com.artipie.docker.http.ErrorsResponse;
import com.artipie.docker.http.Scope;
import com.artipie.docker.http.ScopeSlice;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.docker.perms.DockerActions;
import com.artipie.docker.perms.DockerRepositoryPermission;
import com.artipie.docker.ref.ManifestRef;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.AuthzSlice;
import com.artipie.http.auth.OperationControl;
import com.artipie.http.headers.Accept;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.ContentType;
import com.artipie.http.headers.Location;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.security.policy.Policy;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class ManifestEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/manifests/(?<reference>.*)$");

    private ManifestEntity() {
    }

    static final class BaseResponse
    extends Response.Wrap {
        BaseResponse(Manifest mnf) {
            super((Response)new RsWithHeaders((Response)StandardRs.EMPTY, new Map.Entry[]{new ContentType(String.join((CharSequence)",", mnf.mediaTypes())), new DigestHeader(mnf.digest())}));
        }
    }

    static final class Request {
        private final RqByRegex rqregex;

        Request(String line) {
            this.rqregex = new RqByRegex(line, PATH);
        }

        RepoName name() {
            return new RepoName.Valid(this.rqregex.path().group("name"));
        }

        ManifestRef reference() {
            return new ManifestRef.FromString(this.rqregex.path().group("reference"));
        }
    }

    public static class PutAuth
    implements ScopeSlice {
        private final Docker docker;
        private final ScopeSlice origin;
        private final Policy<?> policy;
        private final AuthScheme auth;
        private final String rname;

        PutAuth(Docker docker, ScopeSlice origin, AuthScheme auth, Policy<?> policy, String name) {
            this.docker = docker;
            this.origin = origin;
            this.policy = policy;
            this.auth = auth;
            this.rname = name;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(name).manifests().get(ref).thenApply(manifest -> {
                OperationControl control = manifest.isPresent() ? new OperationControl(this.policy, (Permission)this.permission(line, this.rname)) : new OperationControl(this.policy, (Permission)new DockerRepositoryPermission(this.rname, new Request(line).name().value(), DockerActions.PUSH.mask() & DockerActions.OVERWRITE.mask()));
                return new DockerAuthSlice((Slice)new AuthzSlice((Slice)this.origin, this.auth, control)).response(line, headers, body);
            }));
        }

        @Override
        public DockerRepositoryPermission permission(String line, String name) {
            return new DockerRepositoryPermission(name, new Scope.Repository.OverwriteTags(new Request(line).name()));
        }
    }

    public static class Put
    implements ScopeSlice {
        private final Docker docker;

        Put(Docker docker) {
            this.docker = docker;
        }

        @Override
        public DockerRepositoryPermission permission(String line, String name) {
            return new DockerRepositoryPermission(name, new Scope.Repository.Push(new Request(line).name()));
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(name).manifests().put(ref, (Content)new Content.From(body)).thenApply(manifest -> new RsWithHeaders((Response)new RsWithStatus(RsStatus.CREATED), new Map.Entry[]{new Location(String.format("/v2/%s/manifests/%s", name.value(), ref.string())), new ContentLength("0"), new DigestHeader(manifest.digest())})));
        }
    }

    public static class Get
    implements ScopeSlice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        @Override
        public DockerRepositoryPermission permission(String line, String name) {
            return new DockerRepositoryPermission(name, new Scope.Repository.Pull(new Request(line).name()));
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(name).manifests().get(ref).thenApply(manifest -> manifest.map(found -> {
                Manifest mnf = found.convert(new HashSet(new Accept(headers).values()));
                return new RsWithBody((Response)new BaseResponse(mnf), mnf.content());
            }).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new ManifestError(ref)))));
        }
    }

    public static class Head
    implements ScopeSlice {
        private final Docker docker;

        Head(Docker docker) {
            this.docker = docker;
        }

        @Override
        public DockerRepositoryPermission permission(String line, String name) {
            return new DockerRepositoryPermission(name, new Scope.Repository.Pull(new Request(line).name()));
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(request.name()).manifests().get(ref).thenApply(manifest -> manifest.map(found -> new RsWithHeaders((Response)new BaseResponse(found.convert(new HashSet(new Accept(headers).values()))), new Map.Entry[]{new ContentLength((Number)found.size())})).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new ManifestError(ref)))));
        }
    }
}

