/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.RepoName;
import com.artipie.docker.perms.DockerActions;
import com.artipie.docker.perms.RegistryCategory;
import com.artipie.security.perms.Action;

public interface Scope {
    public String type();

    public String name();

    public Action action();

    default public String string() {
        return String.format("%s:%s:%s", this.type(), this.name(), this.action());
    }

    public static final class Registry
    implements Scope {
        private final RegistryCategory category;

        public Registry(RegistryCategory category) {
            this.category = category;
        }

        @Override
        public String type() {
            return "registry";
        }

        @Override
        public String name() {
            return "*";
        }

        @Override
        public RegistryCategory action() {
            return this.category;
        }
    }

    public static final class Repository
    implements Scope {
        private final RepoName name;
        private final DockerActions action;

        public Repository(RepoName name, DockerActions action) {
            this.name = name;
            this.action = action;
        }

        @Override
        public String type() {
            return "repository";
        }

        @Override
        public String name() {
            return this.name.value();
        }

        @Override
        public DockerActions action() {
            return this.action;
        }

        static final class OverwriteTags
        extends Wrap {
            OverwriteTags(RepoName name) {
                super(new Repository(name, DockerActions.OVERWRITE));
            }
        }

        static final class Push
        extends Wrap {
            Push(RepoName name) {
                super(new Repository(name, DockerActions.PUSH));
            }
        }

        static final class Pull
        extends Wrap {
            Pull(RepoName name) {
                super(new Repository(name, DockerActions.PULL));
            }
        }
    }

    public static abstract class Wrap
    implements Scope {
        private final Scope scope;

        public Wrap(Scope scope) {
            this.scope = scope;
        }

        @Override
        public final String type() {
            return this.scope.type();
        }

        @Override
        public final String name() {
            return this.scope.name();
        }

        @Override
        public final Action action() {
            return this.scope.action();
        }
    }
}

