/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.manifest;

import com.artipie.asto.Content;
import com.artipie.docker.Digest;
import com.artipie.docker.error.InvalidManifestException;
import com.artipie.docker.manifest.Layer;
import com.artipie.docker.manifest.Manifest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class JsonManifest
implements Manifest {
    private final Digest dgst;
    private final byte[] source;

    public JsonManifest(Digest dgst, byte[] source) {
        this.dgst = dgst;
        this.source = Arrays.copyOf(source, source.length);
    }

    @Override
    public Set<String> mediaTypes() {
        return Collections.unmodifiableSet(Arrays.asList(Optional.ofNullable(this.json().getString("mediaType", null)).orElseThrow(() -> new InvalidManifestException("Required field `mediaType` is absent")).split(",")).stream().filter(type -> !type.isEmpty()).collect(Collectors.toSet()));
    }

    @Override
    public Manifest convert(Set<? extends String> options) {
        Set<String> types;
        if (!options.contains("*/*") && (types = this.mediaTypes()).stream().noneMatch(type -> options.contains(type))) {
            throw new IllegalArgumentException(String.format("Cannot convert from '%s' to any of '%s'", String.join((CharSequence)",", types), options));
        }
        return this;
    }

    @Override
    public Digest config() {
        return new Digest.FromString(this.json().getJsonObject("config").getString("digest"));
    }

    @Override
    public Collection<Layer> layers() {
        return Optional.ofNullable(this.json().getJsonArray("layers")).orElseThrow(() -> new InvalidManifestException("Required field `layers` is absent")).getValuesAs(JsonValue::asJsonObject).stream().map(x$0 -> new JsonLayer((JsonObject)x$0)).collect(Collectors.toList());
    }

    @Override
    public Digest digest() {
        return this.dgst;
    }

    @Override
    public Content content() {
        return new Content.From(this.source);
    }

    @Override
    public long size() {
        return this.source.length;
    }

    private JsonObject json() {
        try (JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(this.source));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    private static final class JsonLayer
    implements Layer {
        private final JsonObject json;

        private JsonLayer(JsonObject json) {
            this.json = json;
        }

        @Override
        public Digest digest() {
            return new Digest.FromString(this.json.getString("digest"));
        }

        @Override
        public Collection<URL> urls() {
            return Optional.ofNullable(this.json.getJsonArray("urls")).map(urls -> urls.getValuesAs(JsonString.class).stream().map(str -> {
                try {
                    return new URL(str.getString());
                }
                catch (MalformedURLException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
    }
}

