/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.misc;

import com.artipie.docker.Catalog;
import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.misc.CatalogPage;
import com.artipie.docker.misc.ParsedCatalog;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class JoinedCatalogSource {
    private final List<Docker> dockers;
    private final Optional<RepoName> from;
    private final int limit;

    public JoinedCatalogSource(Optional<RepoName> from, int limit, Docker ... dockers) {
        this(Arrays.asList(dockers), from, limit);
    }

    public JoinedCatalogSource(List<Docker> dockers, Optional<RepoName> from, int limit) {
        this.dockers = dockers;
        this.from = from;
        this.limit = limit;
    }

    public CompletionStage<Catalog> catalog() {
        List<CompletableFuture> all = this.dockers.stream().map(docker -> docker.catalog(this.from, this.limit).thenApply(ParsedCatalog::new).thenCompose(ParsedCatalog::repos).exceptionally(err -> Collections.emptyList())).collect(Collectors.toList());
        return ((CompletableFuture)CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).thenApply(nothing -> all.stream().flatMap(stage -> ((List)stage.toCompletableFuture().join()).stream()).collect(Collectors.toList()))).thenApply(names -> new CatalogPage((Collection<RepoName>)names, this.from, this.limit));
    }
}

