/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.misc;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.Tags;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;

public final class ParsedTags
implements Tags {
    private final Tags origin;

    public ParsedTags(Tags origin) {
        this.origin = origin;
    }

    @Override
    public Content json() {
        return this.origin.json();
    }

    public CompletionStage<RepoName> repo() {
        return this.root().thenApply(root -> root.getString("name")).thenApply(RepoName.Valid::new);
    }

    public CompletionStage<List<Tag>> tags() {
        return this.root().thenApply(root -> root.getJsonArray("tags")).thenApply(repos -> repos.getValuesAs(JsonString.class).stream().map(JsonString::getString).map(Tag.Valid::new).collect(Collectors.toList()));
    }

    private CompletionStage<JsonObject> root() {
        return new PublisherAs(this.origin.json()).bytes().thenApply(bytes -> Json.createReader((InputStream)new ByteArrayInputStream((byte[])bytes)).readObject());
    }
}

