/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.perms;

import com.artipie.security.perms.Action;
import java.util.Collections;
import java.util.Set;

public enum DockerActions implements Action
{
    PULL(4, "pull"),
    PUSH(2, "push"),
    OVERWRITE(16, "overwrite"),
    ALL(22, "*");

    private final int mask;
    private final String name;

    private DockerActions(int mask, String name) {
        this.mask = mask;
        this.name = name;
    }

    public Set<String> names() {
        return Collections.singleton(this.name);
    }

    public int mask() {
        return this.mask;
    }

    static int maskByAction(String name) {
        for (DockerActions item : DockerActions.values()) {
            if (!item.names().contains(name)) continue;
            return item.mask();
        }
        throw new IllegalArgumentException(String.format("Unknown permission action %s", name));
    }
}

