/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.perms;

import com.artipie.docker.http.Scope;
import com.artipie.docker.perms.RegistryCategory;
import com.artipie.security.perms.Action;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;

public final class DockerRegistryPermission
extends Permission {
    private static final long serialVersionUID = 3016435961451239611L;
    private String actions;
    private final transient int mask;

    public DockerRegistryPermission(String name, int mask) {
        super(name);
        this.mask = mask;
    }

    public DockerRegistryPermission(String name, Scope scope) {
        this(name, scope.action().mask());
    }

    public DockerRegistryPermission(String name, Collection<String> categories) {
        this(name, DockerRegistryPermission.maskFromCategories(categories));
    }

    @Override
    public boolean implies(Permission permission) {
        boolean res;
        if (permission instanceof DockerRegistryPermission) {
            DockerRegistryPermission that = (DockerRegistryPermission)permission;
            res = (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
        } else {
            res = false;
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        DockerRegistryPermission that;
        boolean res = obj == this ? true : (obj instanceof DockerRegistryPermission ? (that = (DockerRegistryPermission)obj).getName().equals(this.getName()) && that.mask == this.mask : false);
        return res;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            StringJoiner joiner = new StringJoiner(",");
            if ((this.mask & RegistryCategory.BASE.mask()) == RegistryCategory.BASE.mask()) {
                joiner.add(RegistryCategory.BASE.name().toLowerCase(Locale.ROOT));
            }
            if ((this.mask & RegistryCategory.CATALOG.mask()) == RegistryCategory.CATALOG.mask()) {
                joiner.add(RegistryCategory.CATALOG.name().toLowerCase(Locale.ROOT));
            }
            this.actions = joiner.toString();
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DockerRegistryPermissionCollection();
    }

    private boolean impliesIgnoreMask(DockerRegistryPermission perm) {
        boolean res = this.getName().equals("*") ? true : this.getName().equalsIgnoreCase(perm.getName());
        return res;
    }

    private static int maskFromCategories(Collection<String> categories) {
        int res = Action.NONE.mask();
        if (categories.isEmpty() || categories.size() == 1 && categories.contains("")) {
            res = Action.NONE.mask();
        } else if (categories.contains("*")) {
            res = RegistryCategory.ANY.mask();
        } else {
            for (String item : categories) {
                res |= RegistryCategory.maskByCategory(item);
            }
        }
        return res;
    }

    public static final class DockerRegistryPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private static final long serialVersionUID = -2153247295984095455L;
        private final transient ConcurrentHashMap<String, Permission> collection = new ConcurrentHashMap(5);
        private boolean any = false;

        @Override
        public void add(Permission obj) {
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            if (obj instanceof DockerRegistryPermission) {
                DockerRegistryPermission perm = (DockerRegistryPermission)obj;
                this.collection.put(perm.getName(), perm);
                if ("*".equals(perm.getName()) && RegistryCategory.ANY.mask() == perm.mask) {
                    this.any = true;
                }
            } else {
                throw new IllegalArgumentException(String.format("Invalid permissions type %s", obj.getClass()));
            }
        }

        @Override
        public boolean implies(Permission permission) {
            boolean res = false;
            if (permission instanceof DockerRegistryPermission) {
                if (this.any) {
                    res = true;
                } else {
                    Permission existing = this.collection.get(permission.getName());
                    if (existing != null) {
                        res = existing.implies(permission);
                    }
                    if (!res && (existing = this.collection.get("*")) != null) {
                        res = existing.implies(permission);
                    }
                }
            }
            return res;
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.collection.elements();
        }
    }
}

