/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.perms;

import com.artipie.docker.http.Scope;
import com.artipie.docker.perms.DockerActions;
import com.artipie.security.perms.Action;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;

public final class DockerRepositoryPermission
extends Permission {
    static final String WILDCARD = "*";
    private static final long serialVersionUID = -2916435271451239611L;
    private String actions;
    private final String resource;
    private final transient int mask;

    public DockerRepositoryPermission(String name, Scope scope) {
        this(name, scope.name(), scope.action().mask());
    }

    public DockerRepositoryPermission(String name, String resource, Collection<String> actions) {
        this(name, resource, DockerRepositoryPermission.maskFromActions(actions));
    }

    public DockerRepositoryPermission(String name, String resource, int mask) {
        super(name);
        this.resource = resource;
        this.mask = mask;
    }

    @Override
    public boolean implies(Permission permission) {
        boolean res;
        if (permission instanceof DockerRepositoryPermission) {
            DockerRepositoryPermission that = (DockerRepositoryPermission)permission;
            res = (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
        } else {
            res = false;
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        DockerRepositoryPermission that;
        boolean res = obj == this ? true : (obj instanceof DockerRepositoryPermission ? (that = (DockerRepositoryPermission)obj).getName().equals(this.getName()) && that.resource.equals(this.resource) && that.mask == this.mask : false);
        return res;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName().hashCode(), this.resource);
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            StringJoiner joiner = new StringJoiner(",");
            if ((this.mask & DockerActions.PULL.mask()) == DockerActions.PULL.mask()) {
                joiner.add(DockerActions.PULL.name().toLowerCase(Locale.ROOT));
            }
            if ((this.mask & DockerActions.PUSH.mask()) == DockerActions.PUSH.mask()) {
                joiner.add(DockerActions.PUSH.name().toLowerCase(Locale.ROOT));
            }
            if ((this.mask & DockerActions.OVERWRITE.mask()) == DockerActions.OVERWRITE.mask()) {
                joiner.add(DockerActions.OVERWRITE.name().toLowerCase(Locale.ROOT));
            }
            this.actions = joiner.toString();
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DockerRepositoryPermissionCollection();
    }

    private boolean impliesIgnoreMask(DockerRepositoryPermission perm) {
        return !(!this.getName().equals(WILDCARD) && !this.getName().equals(perm.getName()) || !this.resource.equals(WILDCARD) && !this.resource.equals(perm.resource));
    }

    private String key() {
        return String.join((CharSequence)":", this.getName(), this.resource);
    }

    private static int maskFromActions(Collection<String> actions) {
        int res = Action.NONE.mask();
        if (actions.isEmpty() || actions.size() == 1 && actions.contains("")) {
            res = Action.NONE.mask();
        } else if (actions.contains(WILDCARD)) {
            res = DockerActions.ALL.mask();
        } else {
            for (String item : actions) {
                res |= DockerActions.maskByAction(item);
            }
        }
        return res;
    }

    public static final class DockerRepositoryPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private static final long serialVersionUID = 5843247295984092155L;
        private final transient ConcurrentHashMap<String, Permission> collection = new ConcurrentHashMap(5);
        private boolean any = false;

        DockerRepositoryPermissionCollection() {
        }

        @Override
        public void add(Permission obj) {
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            if (obj instanceof DockerRepositoryPermission) {
                DockerRepositoryPermission perm = (DockerRepositoryPermission)obj;
                String key = perm.key();
                this.collection.put(key, perm);
                if (DockerRepositoryPermissionCollection.anyActionAllowed(perm)) {
                    this.any = true;
                }
            } else {
                throw new IllegalArgumentException(String.format("Invalid permissions type %s", obj.getClass()));
            }
        }

        @Override
        public boolean implies(Permission obj) {
            boolean res = false;
            if (obj instanceof DockerRepositoryPermission) {
                DockerRepositoryPermission perm = (DockerRepositoryPermission)obj;
                if (this.any) {
                    res = true;
                } else {
                    Permission existing = this.collection.get(perm.key());
                    if (existing != null) {
                        res = existing.implies(perm);
                    }
                    if (!res) {
                        existing = this.collection.get(String.join((CharSequence)":", perm.getName(), DockerRepositoryPermission.WILDCARD));
                        if (existing != null) {
                            res = existing.implies(perm);
                        }
                        if (!res) {
                            existing = this.collection.get(String.join((CharSequence)":", DockerRepositoryPermission.WILDCARD, perm.resource));
                            if (existing != null) {
                                res = existing.implies(perm);
                            }
                            if (!res && (existing = this.collection.get(String.join((CharSequence)":", DockerRepositoryPermission.WILDCARD, DockerRepositoryPermission.WILDCARD))) != null) {
                                res = existing.implies(perm);
                            }
                        }
                    }
                }
            }
            return res;
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.collection.elements();
        }

        private static boolean anyActionAllowed(DockerRepositoryPermission perm) {
            return perm.getName().equals(DockerRepositoryPermission.WILDCARD) && perm.resource.equals(DockerRepositoryPermission.WILDCARD) && perm.mask == DockerActions.ALL.mask();
        }
    }
}

