/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.perms;

import com.artipie.security.perms.Action;
import java.util.Collections;
import java.util.Set;

public enum RegistryCategory implements Action
{
    BASE("base", 4),
    CATALOG("catalog", 2),
    ANY("*", 6);

    private final String name;
    private final int mask;

    private RegistryCategory(String name, int mask) {
        this.name = name;
        this.mask = mask;
    }

    public Set<String> names() {
        return Collections.singleton(this.name);
    }

    public int mask() {
        return this.mask;
    }

    static int maskByCategory(String name) {
        for (RegistryCategory item : RegistryCategory.values()) {
            if (!item.names().contains(name)) continue;
            return item.mask();
        }
        throw new IllegalArgumentException(String.format("Unknown permission action %s", name));
    }
}

