/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.docker.RepoName;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CatalogUri {
    private final Optional<RepoName> from;
    private final int limit;

    CatalogUri(Optional<RepoName> from, int limit) {
        this.from = from;
        this.limit = limit;
    }

    public String string() {
        Stream<Object> nparam = this.limit < Integer.MAX_VALUE ? Stream.of(String.format("n=%d", this.limit)) : Stream.empty();
        List params = Stream.concat(nparam, this.from.map(name -> Stream.of(String.format("last=%s", name.value()))).orElseGet(Stream::empty)).collect(Collectors.toList());
        StringBuilder uri = new StringBuilder("/v2/_catalog");
        if (!params.isEmpty()) {
            uri.append(String.format("?%s", Joiner.on((String)"&").join(params)));
        }
        return uri.toString();
    }
}

