/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.files;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RequestLineFrom;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.utils.URIBuilder;
import org.reactivestreams.Publisher;

public final class FileProxySlice
implements Slice {
    private final Slice client;

    public FileProxySlice(ClientSlices clients, URI remote) {
        this(new ClientSlice(clients, remote));
    }

    private FileProxySlice(Slice client) {
        this.client = client;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.client.response(line, headers, body);
    }

    private static final class ClientSlice
    implements Slice {
        private final ClientSlices clients;
        private final URI remote;

        ClientSlice(ClientSlices clients, URI remote) {
            this.clients = clients;
            this.remote = remote;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Slice slice;
            String scheme;
            String host = this.remote.getHost();
            int port = this.remote.getPort();
            switch (scheme = this.remote.getScheme()) {
                case "https": {
                    slice = this.clients.https(host, port);
                    break;
                }
                case "http": {
                    slice = this.clients.http(host, port);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Scheme '%s' is not supported", scheme));
                }
            }
            RequestLineFrom rqline = new RequestLineFrom(line);
            URI uri = rqline.uri();
            return slice.response(new RequestLine(rqline.method().value(), new URIBuilder(uri).setPath(ClientSlice.concatPaths(this.remote.getPath(), uri.getPath())).toString(), rqline.version()).toString(), headers, body);
        }

        private static String concatPaths(String ... paths) {
            String rel = Stream.of(paths).map(path -> path.replaceAll("(?:^/|/$)", "")).flatMap(path -> Arrays.stream(path.split("/"))).filter(part -> !part.isEmpty()).collect(Collectors.joining("/"));
            return String.format("/%s", rel);
        }
    }
}

