/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.files;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.files.BlobListFormat;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.slice.KeyFromPath;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class ListBlobsSlice
implements Slice {
    private final Storage storage;
    private final BlobListFormat format;
    private final String mtype;
    private final Function<String, Key> transform;

    public ListBlobsSlice(Storage storage, BlobListFormat format, String mtype) {
        this(storage, format, mtype, KeyFromPath::new);
    }

    public ListBlobsSlice(Storage storage, BlobListFormat format, String mtype, Function<String, Key> transform) {
        this.storage = storage;
        this.format = format;
        this.mtype = mtype;
        this.transform = transform;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(CompletableFuture.supplyAsync(() -> ((RequestLineFrom)new RequestLineFrom(line)).uri()).thenCompose(uri -> {
            Key key = this.transform.apply(uri.getPath());
            return this.storage.list(key).thenApply(keys -> {
                String text = this.format.apply((Collection<? extends Key>)keys);
                return new RsFull(RsStatus.OK, (Iterable)new Headers.From((Map.Entry)new ContentType(this.mtype)), (Content)new Content.From(text.getBytes(StandardCharsets.UTF_8)));
            });
        }));
    }
}

