/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.files;

import com.artipie.asto.Key;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.json.Json;

@FunctionalInterface
interface BlobListFormat {
    public String apply(Collection<? extends Key> var1);

    public static enum Standard implements BlobListFormat
    {
        TEXT(keys -> keys.stream().map(Key::string).collect(Collectors.joining("\n"))),
        JSON(keys -> Json.createArrayBuilder((Collection)keys.stream().map(Key::string).collect(Collectors.toList())).build().toString()),
        HTML(keys -> String.format(String.join((CharSequence)"\n", "<!DOCTYPE html>", "<html>", "  <head><meta charset=\"utf-8\"/></head>", "  <body>", "    <ul>", "%s", "    </ul>", "  </body>", "</html>"), keys.stream().map(key -> String.format("      <li><a href=\"/%s\">%s</a></li>", key.string(), key.string())).collect(Collectors.joining("\n"))));

        private final BlobListFormat fmt;

        private Standard(BlobListFormat fmt) {
            this.fmt = fmt;
        }

        @Override
        public String apply(Collection<? extends Key> blobs) {
            return this.fmt.apply(blobs);
        }
    }
}

