/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.files;

import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqParams;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.slice.KeyFromPath;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class FileMetaSlice
implements Slice {
    private static final String META_PARAM = "meta";
    private final Storage storage;
    private final Slice origin;

    public FileMetaSlice(Slice origin, Storage storage) {
        this.origin = origin;
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> iterable, Publisher<ByteBuffer> publisher) {
        Response response;
        Response raw = this.origin.response(line, iterable, publisher);
        URI uri = new RequestLineFrom(line).uri();
        Optional meta = new RqParams(uri).value(META_PARAM);
        if (meta.isPresent() && Boolean.parseBoolean((String)meta.get())) {
            KeyFromPath key = new KeyFromPath(uri.getPath());
            response = new AsyncResponse(this.storage.exists((Key)key).thenCompose(arg_0 -> this.lambda$response$1((Key)key, raw, arg_0)));
        } else {
            response = raw;
        }
        return response;
    }

    private /* synthetic */ CompletionStage lambda$response$1(Key key, Response raw, Boolean exist) {
        CompletionStage<Object> result = exist != false ? this.storage.metadata(key).thenApply(mtd -> new RsWithHeaders(raw, (Headers)new FileHeaders((Meta)mtd))) : CompletableFuture.completedFuture(raw);
        return result;
    }

    private static final class FileHeaders
    extends Headers.Wrap {
        FileHeaders(Meta mtd) {
            super((Iterable)FileHeaders.from(mtd));
        }

        private static Headers from(Meta mtd) {
            HashMap<Meta.OpRWSimple, String> fmtd = new HashMap<Meta.OpRWSimple, String>();
            fmtd.put(Meta.OP_MD5, "X-Artipie-MD5");
            fmtd.put(Meta.OP_CREATED_AT, "X-Artipie-CreatedAt");
            fmtd.put(Meta.OP_SIZE, "X-Artipie-Size");
            HashMap hdrs = new HashMap();
            for (Map.Entry entry : fmtd.entrySet()) {
                hdrs.put(entry.getValue(), ((Optional)mtd.read((Meta.ReadOperator)entry.getKey())).get().toString());
            }
            return new Headers.From(hdrs.entrySet());
        }
    }
}

