/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.files;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.FromRemoteCache;
import com.artipie.asto.cache.Remote;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.UriClientSlice;
import com.artipie.http.client.auth.AuthClientSlice;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.KeyFromPath;
import io.reactivex.Flowable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class FileProxySlice
implements Slice {
    private final Slice remote;
    private final Cache cache;

    public FileProxySlice(ClientSlices clients, URI remote) {
        this((Slice)new UriClientSlice(clients, remote), Cache.NOP);
    }

    public FileProxySlice(ClientSlices clients, URI remote, Authenticator auth, Storage asto) {
        this((Slice)new AuthClientSlice((Slice)new UriClientSlice(clients, remote), auth), (Cache)new FromRemoteCache(asto));
    }

    public FileProxySlice(ClientSlices clients, URI remote, Authenticator auth, Cache cache) {
        this((Slice)new AuthClientSlice((Slice)new UriClientSlice(clients, remote), auth), cache);
    }

    FileProxySlice(Slice remote, Cache cache) {
        this.remote = remote;
        this.cache = cache;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> ignored, Publisher<ByteBuffer> pub) {
        AtomicReference headers = new AtomicReference();
        return new AsyncResponse(this.cache.load((Key)new KeyFromPath(new RequestLineFrom(line).uri().getPath()), (Remote)new Remote.WithErrorHandling(() -> {
            CompletableFuture promise = new CompletableFuture();
            this.remote.response(line, (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((rsstatus, rsheaders, rsbody) -> {
                CompletableFuture term = new CompletableFuture();
                headers.set(rsheaders);
                if (rsstatus.success()) {
                    Flowable body = Flowable.fromPublisher((Publisher)rsbody).doOnError(term::completeExceptionally).doOnTerminate(() -> term.complete(null));
                    promise.complete(Optional.of(new Content.From((Publisher)body)));
                } else {
                    promise.complete(Optional.empty());
                }
                return term;
            });
            return promise;
        }), (CacheControl)CacheControl.Standard.ALWAYS).handle((content, throwable) -> {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            if (throwable == null && content.isPresent()) {
                result.complete(new RsFull(RsStatus.OK, (Iterable)new Headers.From((Iterable)headers.get()), (Content)content.get()));
            } else {
                result.complete(new RsWithStatus(RsStatus.NOT_FOUND));
            }
            return result;
        }).thenCompose(Function.identity()));
    }
}

