/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.jcabi.log.Logger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class GemInfo
implements Slice {
    public static final Pattern PATH_PATTERN = Pattern.compile("/api/v1/gems/([\\w]+).(json|yml)");
    private final Storage storage;

    public GemInfo(Storage storage) {
        this.storage = storage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PATH_PATTERN.matcher(new RequestLineFrom(line).uri().toString());
        if (!matcher.find()) throw new IllegalStateException("Not expected path has been matched");
        String gem = matcher.group(1);
        String extension = matcher.group(2);
        Logger.info(GemInfo.class, (String)"Gem info for '%s' has been requested. Extension: '%s'", (Object[])new Object[]{gem, extension});
        if (extension.equals("json")) {
            return new RsWithStatus(RsStatus.NOT_IMPLEMENTED);
        }
        if (!extension.equals("yml")) throw new IllegalStateException("Not expected extension format has been matched");
        return new RsWithStatus(RsStatus.NOT_IMPLEMENTED);
    }
}

