/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Identities;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;

public final class ApiKeySlice
implements Slice {
    private static final String PREFIX = "Basic ";
    private final Identities users;

    public ApiKeySlice(Identities users) {
        this.users = users;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus response;
        Optional user = this.users.user(line, headers);
        if (user.isPresent()) {
            String key = new RqHeaders(headers, "Authorization").stream().findFirst().filter(hdr -> hdr.startsWith(PREFIX)).map(hdr -> hdr.substring(PREFIX.length())).get();
            response = new RsWithBody(key, StandardCharsets.UTF_8);
        } else {
            response = new RsWithStatus(RsStatus.UNAUTHORIZED);
        }
        return response;
    }
}

