/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.asto.Remaining;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;

public final class ByteFlowIntoStringConversion {
    private final Publisher<ByteBuffer> flow;

    public ByteFlowIntoStringConversion(Publisher<ByteBuffer> flow) {
        this.flow = flow;
    }

    public Single<String> string(Charset charset) {
        return Flowable.fromPublisher(this.flow).toList().map(bufs -> {
            int counter = 0;
            for (ByteBuffer buf : bufs) {
                counter += buf.remaining();
            }
            ByteBuffer bytes = ByteBuffer.allocate(counter);
            for (ByteBuffer buf : bufs) {
                bytes.put(new Remaining(buf).bytes());
            }
            return new String(bytes.array(), charset);
        });
    }

    public Single<String> string() {
        return this.string(StandardCharsets.UTF_8);
    }
}

