/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.gem.GemMeta;
import com.artipie.gem.UncheckedSupplier;
import com.artipie.gem.ruby.RubyGemIndex;
import com.artipie.gem.ruby.RubyGemMeta;
import com.artipie.gem.ruby.SharedRuntime;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public final class Gem {
    private static final Set<Key> META_NAMES = Collections.unmodifiableSet(Stream.of("latest_specs.4.8", "latest_specs.4.8.gz", "prerelease_specs.4.8", "prerelease_specs.4.8.gz", "specs.4.8", "specs.4.8.gz").map(Key.From::new).collect(Collectors.toSet()));
    private final Storage storage;
    private final SharedRuntime shared;

    public Gem(Storage storage) {
        this.storage = storage;
        this.shared = new SharedRuntime();
    }

    public CompletionStage<Void> update(Key gem) {
        AtomicReference dir = new AtomicReference();
        return Gem.newTempDir().thenCompose(tmp -> {
            dir.set(tmp);
            return new Copy(this.storage, key -> META_NAMES.contains(key) || key.equals(gem)).copy((Storage)new FileStorage(tmp)).thenApply(ignore -> tmp);
        }).thenCompose(tmp -> this.shared.apply(RubyGemMeta::new).thenApply(meta -> meta.info(Paths.get(tmp.toString(), gem.string()), (Map<String, String> spec) -> String.format("%s-%s.gem", spec.get("name"), spec.get("version")))).thenApply(new UncheckedIOFunc(name -> {
            Path path = Paths.get(tmp.toString(), gem.string());
            Path target = path.getParent().resolve((String)name);
            Files.move(path, target, new CopyOption[0]);
            return target;
        }))).thenCompose(fullpath -> this.shared.apply(RubyGemIndex::new).thenAccept(index -> index.update((Path)fullpath)).thenCompose(none -> new Copy((Storage)new FileStorage((Path)dir.get())).copy(this.storage)).handle(Gem.removeTempDir((Path)dir.get())));
    }

    public <T> CompletionStage<T> info(String gem, GemMeta.InfoFormat<T> fmt) {
        return Gem.newTempDir().thenCompose(tmp -> new Copy(this.storage, (Predicate)new IsGemKey(gem)).copy((Storage)new FileStorage(tmp)).thenApply(ignore -> tmp)).thenCompose(tmp -> this.shared.apply(RubyGemMeta::new).thenCompose(info -> new FileStorage(tmp).list(Key.ROOT).thenApply(items -> items.stream().findFirst().map(first -> Paths.get(tmp.toString(), first.string())).map(path -> info.info((Path)path, fmt)).orElseThrow(() -> new ArtipieIOException("gem not found")))).handle(Gem.removeTempDir(tmp)));
    }

    private static CompletionStage<Path> newTempDir() {
        return CompletableFuture.supplyAsync(new UncheckedSupplier<Path>(() -> Files.createTempDirectory(Gem.class.getSimpleName(), new FileAttribute[0])));
    }

    private static <T> BiFunction<T, Throwable, T> removeTempDir(Path tmpdir) {
        return (res, err) -> {
            try {
                if (tmpdir != null) {
                    FileUtils.deleteDirectory((File)new File(tmpdir.toString()));
                }
            }
            catch (IOException iox) {
                throw new ArtipieIOException(iox);
            }
            if (err != null) {
                throw new CompletionException((Throwable)err);
            }
            return res;
        };
    }

    private static final class IsGemKey
    implements Predicate<Key> {
        private final String name;

        IsGemKey(String name) {
            this.name = name;
        }

        @Override
        public boolean test(Key key) {
            String tail;
            String str = key.string();
            int idx = str.lastIndexOf(this.name);
            boolean matches = false;
            if (idx >= 0 && ((tail = str.substring(idx + this.name.length())).isEmpty() || tail.matches("^[0-9a-zA-Z\\-\\.]+$"))) {
                matches = true;
            }
            return matches;
        }
    }
}

