/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.BasicAuthScheme;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cactoos.text.Base64Decoded;

public final class GemApiKeyAuth
implements AuthScheme {
    private final Authentication auth;

    public GemApiKeyAuth(Authentication auth) {
        this.auth = auth;
    }

    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(str -> {
            CompletableFuture<AuthScheme.Result> res = str.startsWith("Basic") ? new BasicAuthScheme(this.auth).authenticate(headers) : CompletableFuture.completedFuture(Optional.of(str).map(Base64Decoded::new).map(dec -> dec.toString().split(":")).flatMap(cred -> this.auth.user(cred[0].trim(), cred[1].trim())).map(Success::new).orElseGet(() -> new Failure()));
            return res;
        }).get();
    }

    private static class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        public Optional<Authentication.User> user() {
            return Optional.empty();
        }

        public String challenge() {
            return "";
        }
    }

    private static class Success
    implements AuthScheme.Result {
        private final Authentication.User usr;

        Success(Authentication.User user) {
            this.usr = user;
        }

        public Optional<Authentication.User> user() {
            return Optional.of(this.usr);
        }

        public String challenge() {
            return "";
        }
    }
}

