/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.http;

import com.artipie.asto.Storage;
import com.artipie.gem.Gem;
import com.artipie.gem.GemMeta;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.common.RsJson;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonStructure;
import org.reactivestreams.Publisher;

public final class ApiGetSlice
implements Slice {
    public static final Pattern PATH_PATTERN = Pattern.compile("/api/v1/gems/([\\w]+).(json|yml)");
    private final Gem sdk;

    public ApiGetSlice(Storage storage) {
        this.sdk = new Gem(storage);
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PATH_PATTERN.matcher(new RequestLineFrom(line).uri().toString());
        if (!matcher.find()) {
            throw new IllegalStateException("Invalid routing schema");
        }
        return new AsyncResponse(this.sdk.info(matcher.group(1), GemMeta.FMT_JSON).thenApply(json -> new RsJson((JsonStructure)json)));
    }
}

