/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.http;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.BasicAuthScheme;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class ApiKeySlice
implements Slice {
    private final Authentication auth;

    public ApiKeySlice(Authentication auth) {
        this.auth = auth;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(new BasicAuthScheme(this.auth).authenticate(headers).thenApply(AuthScheme.Result::user).thenApply(usr -> {
            RsWithStatus response;
            if (usr.isPresent()) {
                String key = new RqHeaders(headers, "Authorization").stream().findFirst().filter(hdr -> hdr.startsWith("Basic")).map(hdr -> hdr.substring("Basic".length() + 1)).get();
                response = new RsWithBody((CharSequence)key, StandardCharsets.UTF_8);
            } else {
                response = new RsWithStatus(RsStatus.UNAUTHORIZED);
            }
            return response;
        }));
    }
}

