/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.ruby;

import com.artipie.gem.GemMeta;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.javasupport.JavaEmbedUtils;

public final class RubyGemMeta
implements GemMeta {
    private final Ruby ruby;

    public RubyGemMeta(Ruby ruby) {
        this.ruby = ruby;
    }

    @Override
    public <T> T info(Path gem, GemMeta.InfoFormat<T> fmt) {
        RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
        adapter.eval(this.ruby, "require 'rubygems/package.rb'");
        RubyObject spec = (RubyObject)adapter.eval(this.ruby, String.format("Gem::Package.new('%s').spec", gem.toString()));
        Map<String, String> data = spec.getVariableList().stream().filter(item -> item.getValue() != null).collect(Collectors.toMap(item -> item.getName().substring(1), item -> item.getValue().toString()));
        return fmt.print(data);
    }
}

