/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.ruby;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;

public final class SharedRuntime {
    private final Supplier<Ruby> factory;
    private final Object lock;
    private volatile Ruby runtime;

    public SharedRuntime() {
        this(() -> JavaEmbedUtils.initialize(Collections.emptyList()));
    }

    public SharedRuntime(Supplier<Ruby> factory) {
        this.factory = factory;
        this.lock = new Object();
    }

    public <T> CompletionStage<T> apply(Function<Ruby, T> applier) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.runtime == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.runtime == null) {
                        this.runtime = this.factory.get();
                    }
                }
            }
            return applier.apply(this.runtime);
        });
    }
}

