/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.misc.UncheckedSupplier;
import com.artipie.gem.GemKeyPredicate;
import com.artipie.gem.GemMeta;
import com.artipie.gem.ruby.RubyGemDependencies;
import com.artipie.gem.ruby.RubyGemIndex;
import com.artipie.gem.ruby.RubyGemMeta;
import com.artipie.gem.ruby.SharedRuntime;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import wtf.g4s8.tuples.Pair;

public final class Gem {
    private static final Set<Key> META_NAMES = Collections.unmodifiableSet(Stream.of("latest_specs.4.8", "latest_specs.4.8.gz", "prerelease_specs.4.8", "prerelease_specs.4.8.gz", "specs.4.8", "specs.4.8.gz").map(Key.From::new).collect(Collectors.toSet()));
    private final Storage storage;
    private final SharedRuntime shared;

    public Gem(Storage storage) {
        this.storage = storage;
        this.shared = new SharedRuntime();
    }

    public CompletionStage<Void> update(Key gem) {
        return Gem.newTempDir().thenCompose(tmp -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)new Copy(this.storage, key -> META_NAMES.contains(key) || key.equals(gem)).copy((Storage)new FileStorage(tmp)).thenCompose(ignore -> this.shared.apply(RubyGemMeta::new).thenApply(meta -> meta.info(tmp.resolve(gem.string()))).thenApply(info -> info.toString(new RevisionFormat())))).thenApplyAsync((Function)new UncheckedIOFunc(name -> Files.move(tmp.resolve(gem.string()), gem.parent().map(key -> tmp.resolve(key.string())).orElse((Path)tmp).resolve((String)name), new CopyOption[0])))).thenCompose(path -> this.shared.apply(RubyGemIndex::new).thenAcceptAsync(index -> index.update((Path)path)))).thenCompose(ignore -> new Copy((Storage)new FileStorage(tmp)).copy(this.storage))).handle(Gem.removeTempDir(tmp)));
    }

    public CompletionStage<GemMeta.MetaInfo> info(String gem) {
        return Gem.newTempDir().thenCompose(tmp -> new Copy(this.storage, (Predicate)new GemKeyPredicate(gem)).copy((Storage)new FileStorage(tmp)).thenApply(ignore -> tmp)).thenCompose(tmp -> this.shared.apply(RubyGemMeta::new).thenCompose(info -> new FileStorage(tmp).list(Key.ROOT).thenApply(items -> items.stream().findFirst().map(first -> Paths.get(tmp.toString(), first.string())).map(path -> info.info((Path)path)).orElseThrow(() -> new ArtipieIOException("gem not found")))).handle(Gem.removeTempDir(tmp)));
    }

    public CompletionStage<ByteBuffer> dependencies(Set<? extends String> gems) {
        return Gem.newTempDir().thenCompose(tmp -> ((CompletableFuture)new Copy(this.storage, (Predicate)new GemKeyPredicate(gems)).copy((Storage)new FileStorage(tmp)).thenCompose(ignore -> this.shared.apply(RubyGemDependencies::new).thenCompose(deps -> ((CompletableFuture)new FileStorage(tmp).list(Key.ROOT).thenApply(keys -> keys.stream().map(key -> tmp.resolve(key.string())).collect(Collectors.toSet()))).thenApply(paths -> Pair.of((Object)deps, (Object)paths))).thenApply(tuple -> (ByteBuffer)tuple.apply((deps, paths) -> deps.dependencies((Set<? extends Path>)paths))))).handle(Gem.removeTempDir(tmp)));
    }

    private static CompletionStage<Path> newTempDir() {
        return CompletableFuture.supplyAsync(new UncheckedSupplier(() -> Files.createTempDirectory(Gem.class.getSimpleName(), new FileAttribute[0])));
    }

    private static <T> BiFunction<T, Throwable, T> removeTempDir(Path tmpdir) {
        return (res, err) -> {
            try {
                if (tmpdir != null) {
                    FileUtils.deleteDirectory((File)new File(tmpdir.toString()));
                }
            }
            catch (IOException iox) {
                throw new ArtipieIOException(iox);
            }
            if (err != null) {
                throw new CompletionException((Throwable)err);
            }
            return res;
        };
    }

    private static final class RevisionFormat
    implements GemMeta.MetaFormat {
        private String name;
        private String version;

        private RevisionFormat() {
        }

        @Override
        public void print(String nme, String value) {
            if (nme.equals("name")) {
                this.name = value;
            }
            if (nme.equals("version")) {
                this.version = value;
            }
        }

        @Override
        public void print(String nme, GemMeta.MetaInfo value) {
        }

        @Override
        public void print(String nme, String[] values) {
        }

        public String toString() {
            return String.format("%s-%s.gem", this.name, this.version);
        }
    }
}

