/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.AuthUser;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.BasicAuthScheme;
import com.artipie.http.rq.RqHeaders;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.codec.binary.Base64;

public final class GemApiKeyAuth
implements AuthScheme {
    private final Authentication auth;

    public GemApiKeyAuth(Authentication auth) {
        this.auth = auth;
    }

    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers, String header) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(str -> {
            CompletableFuture<AuthScheme.Result> res = str.startsWith("Basic") ? new BasicAuthScheme(this.auth).authenticate(headers) : CompletableFuture.completedFuture(Optional.of(str).map(item -> item.getBytes(StandardCharsets.UTF_8)).map(Base64::decodeBase64).map(String::new).map(dec -> dec.split(":")).flatMap(cred -> this.auth.user(cred[0].trim(), cred[1].trim())).map(Success::new).orElseGet(() -> new Failure()));
            return res;
        }).get();
    }

    private static class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        public Optional<AuthUser> user() {
            return Optional.empty();
        }

        public String challenge() {
            return "";
        }
    }

    private static class Success
    implements AuthScheme.Result {
        private final AuthUser usr;

        Success(AuthUser user) {
            this.usr = user;
        }

        public Optional<AuthUser> user() {
            return Optional.of(this.usr);
        }

        public String challenge() {
            return "";
        }
    }
}

