/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem;

import com.artipie.asto.Key;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

final class GemKeyPredicate
implements Predicate<Key> {
    private static final Pattern PTN_TAIL = Pattern.compile("^[0-9a-zA-Z\\-\\.]+\\.gem$");
    private final Set<? extends String> names;

    GemKeyPredicate(String name) {
        this(Collections.singleton(name));
    }

    GemKeyPredicate(Set<? extends String> names) {
        this.names = names;
    }

    @Override
    public boolean test(Key target) {
        String gem = target.string();
        return this.names.stream().anyMatch(name -> GemKeyPredicate.testOne(name, gem));
    }

    private static boolean testOne(String name, String target) {
        String tail;
        int idx = target.lastIndexOf(name);
        boolean matches = false;
        if (idx >= 0 && ((tail = target.substring(idx + name.length())).isEmpty() || PTN_TAIL.matcher(tail).matches())) {
            matches = true;
        }
        return matches;
    }
}

