/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.http;

import com.artipie.asto.Storage;
import com.artipie.gem.Gem;
import com.artipie.gem.http.MetaResponseFormat;
import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class ApiGetSlice
implements Slice {
    public static final Pattern PATH_PATTERN = Pattern.compile("/api/v1/gems/(?<name>[\\w\\d-]+).(?<fmt>json|yaml)");
    private final Gem sdk;

    ApiGetSlice(Storage storage) {
        this.sdk = new Gem(storage);
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PATH_PATTERN.matcher(new RequestLineFrom(line).uri().toString());
        if (!matcher.find()) {
            throw new ArtipieHttpException(RsStatus.BAD_REQUEST, String.format("Invalid URI: `%s`", matcher.toString()));
        }
        return new AsyncResponse(this.sdk.info(matcher.group("name")).thenApply(MetaResponseFormat.byName(matcher.group("fmt"))));
    }
}

