/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.http;

import com.artipie.gem.GemMeta;
import com.artipie.gem.JsonMetaFormat;
import com.artipie.gem.YamlMetaFormat;
import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Response;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.rs.common.RsJson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;

enum MetaResponseFormat implements Function<GemMeta.MetaInfo, Response>
{
    JSON{

        @Override
        public Response apply(GemMeta.MetaInfo meta) {
            JsonObjectBuilder json = Json.createObjectBuilder();
            meta.print(new JsonMetaFormat(json));
            return new RsJson((JsonStructure)json.build());
        }
    }
    ,
    YAML{

        @Override
        public Response apply(GemMeta.MetaInfo meta) {
            YamlMetaFormat.Yamler yamler = new YamlMetaFormat.Yamler();
            meta.print(new YamlMetaFormat(yamler));
            Charset charset = StandardCharsets.UTF_8;
            return new RsWithHeaders((Response)new RsWithBody((Response)StandardRs.OK, (CharSequence)yamler.build().toString(), charset), new Map.Entry[]{new ContentType(String.format("text/x-yaml;charset=%s", charset.displayName().toLowerCase(Locale.US)))});
        }
    };


    static MetaResponseFormat byName(String name) {
        MetaResponseFormat res;
        switch (name) {
            case "json": {
                res = JSON;
                break;
            }
            case "yaml": {
                res = YAML;
                break;
            }
            default: {
                throw new ArtipieHttpException(RsStatus.BAD_REQUEST, String.format("unsupported format type `%s`", name));
            }
        }
        return res;
    }
}

