/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.ruby;

import com.artipie.asto.ArtipieIOException;
import com.artipie.gem.GemDependencies;
import com.artipie.gem.ruby.SharedRuntime;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;

public final class RubyGemDependencies
implements GemDependencies,
SharedRuntime.RubyPlugin {
    private final Ruby ruby;

    public RubyGemDependencies(Ruby ruby) {
        this.ruby = ruby;
    }

    @Override
    public ByteBuffer dependencies(Set<? extends Path> gems) {
        String raw = (String)JavaEmbedUtils.invokeMethod((Ruby)this.ruby, (Object)JavaEmbedUtils.newRuntimeAdapter().eval(this.ruby, "Dependencies"), (String)"dependencies", (Object[])new Object[]{gems.stream().map(Path::toString).collect(Collectors.toList()).toArray(new String[0])}, String.class);
        return ByteBuffer.wrap(raw.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String identifier() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void initialize() {
        try {
            JavaEmbedUtils.newRuntimeAdapter().eval(this.ruby, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/dependencies.rb"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException err) {
            throw new ArtipieIOException("Failed to load dependencies script", err);
        }
    }
}

