/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.gem.ruby;

import com.artipie.gem.GemMeta;
import com.artipie.gem.ruby.SharedRuntime;
import java.nio.file.Path;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public final class RubyGemMeta
implements GemMeta,
SharedRuntime.RubyPlugin {
    private final Ruby ruby;

    public RubyGemMeta(Ruby ruby) {
        this.ruby = ruby;
    }

    @Override
    public GemMeta.MetaInfo info(Path gem) {
        RubyObject spec = (RubyObject)JavaEmbedUtils.newRuntimeAdapter().eval(this.ruby, String.format("Gem::Package.new('%s').spec", gem.toString()));
        return new RubyMetaInfo(spec);
    }

    @Override
    public String identifier() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void initialize() {
        JavaEmbedUtils.newRuntimeAdapter().eval(this.ruby, "require 'rubygems/package.rb'");
    }

    private static final class RubyMetaInfo
    implements GemMeta.MetaInfo {
        private final RubyObject spec;

        RubyMetaInfo(RubyObject spec) {
            this.spec = spec;
        }

        @Override
        public void print(GemMeta.MetaFormat fmt) {
            fmt.print("name", this.spec.getInstanceVariable("@name").asJavaString());
            fmt.print("version", this.spec.getInstanceVariable("@version").getInstanceVariables().getInstanceVariable("@version").asJavaString());
            fmt.print("platform", this.spec.getInstanceVariable("@platform").asJavaString());
            fmt.print("authors", RubyMetaInfo.rubyToJavaStringArray(this.spec.getInstanceVariable("@authors").convertToArray()));
            fmt.print("info", this.spec.getInstanceVariable("@description").asJavaString());
            fmt.print("licenses", RubyMetaInfo.rubyToJavaStringArray(this.spec.getInstanceVariable("@licenses").convertToArray()));
            fmt.print("homepage_uri", this.spec.getInstanceVariable("@homepage").asJavaString());
        }

        private static String[] rubyToJavaStringArray(RubyArray<?> src) {
            IRubyObject[] jarr = src.toJavaArray();
            String[] res = new String[jarr.length];
            for (int id = 0; id < jarr.length; ++id) {
                res[id] = jarr[id].asJavaString();
            }
            return res;
        }
    }
}

