/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.goproxy;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.RxFile;
import com.artipie.asto.rx.RxStorageWrapper;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.reactivex.core.Vertx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cactoos.list.Joined;
import org.cactoos.list.ListOf;
import org.reactivestreams.Publisher;

public final class Goproxy {
    private final RxStorageWrapper storage;
    private final Vertx vertx;

    public Goproxy(Storage stg, Vertx vertx) {
        this.vertx = vertx;
        this.storage = new RxStorageWrapper(stg);
    }

    public Completable update(String repo, String version) {
        return Completable.defer(() -> this.actualUpdate(repo, version));
    }

    static Single<Content> generateVersionedJson(String version, Instant timestamp) {
        return Single.just((Object)new Content.From(String.format("{\"Version\":\"v%s\",\"Time\":\"%s\"}", version, DateTimeFormatter.ISO_INSTANT.format(timestamp.truncatedTo(ChronoUnit.SECONDS))).getBytes()));
    }

    static Single<ByteBuffer> readCompletely(Content content) {
        return Flowable.fromPublisher((Publisher)content).reduce((Object)ByteBuffer.allocate(0), (left, right) -> ByteBuffer.allocate(left.remaining() + right.remaining()).put((ByteBuffer)left).put((ByteBuffer)right).flip());
    }

    private Completable actualUpdate(String repo, String version) throws IOException {
        String[] parts = repo.split("/", 2);
        String lkey = String.format("%s/@v/list", repo);
        return Completable.concatArray((CompletableSource[])new CompletableSource[]{this.loadGoModFile(parts).flatMapCompletable(content -> this.saveModWithVersion(repo, version, (Content)content)), this.archive(String.format("%s/", parts[1]), String.format("%s@v%s", repo, version)).flatMapCompletable(zip -> this.storage.save((Key)new Key.From(String.format("%s/@v/v%s.zip", repo, version)), (Content)new Content.From((Publisher)new RxFile(zip, this.vertx.fileSystem()).flow())).andThen((CompletableSource)Completable.fromAction(() -> Files.delete(zip)))), Goproxy.generateVersionedJson(version, Instant.now()).flatMapCompletable(content -> this.storage.save((Key)new Key.From(String.format("%s/@v/v%s.info", repo, version)), content)), this.storage.exists((Key)new Key.From(lkey)).flatMap(exists -> {
            if (exists.booleanValue()) {
                return this.storage.value((Key)new Key.From(lkey));
            }
            return Single.just((Object)new Content.From(new byte[0]));
        }).flatMap(content -> Goproxy.updateFileList(version, content)).flatMapCompletable(content -> this.storage.save((Key)new Key.From(lkey), content))});
    }

    private Single<Content> loadGoModFile(String ... parts) {
        return this.storage.value((Key)new Key.From(String.format("%s/go.mod", parts[1])));
    }

    private Completable saveModWithVersion(String repo, String version, Content content) {
        return this.storage.save((Key)new Key.From(String.format("%s/@v/v%s.mod", repo, version)), content);
    }

    private static Single<Content> updateFileList(String version, Content content) {
        return Goproxy.readCompletely(content).map(buf -> new Remaining(buf).bytes()).map(buf -> Goproxy.appendLineToBuffer(buf, String.format("v%s", version))).map(Content.From::new);
    }

    private static byte[] appendLineToBuffer(byte[] buffer, String line) throws IOException {
        return new org.cactoos.text.Joined("\n", (Iterable)new Joined(new List[]{new ListOf((Object[])new String(buffer).split("\n")), new ListOf((Object[])new String[]{line})})).asString().getBytes();
    }

    private Single<Path> archive(String prefix, String target) throws IOException {
        Path zip = Files.createTempFile("", ".zip", new FileAttribute[0]);
        return this.storage.list((Key)new Key.From(prefix)).flatMapCompletable(keys -> {
            ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zip, new OpenOption[0]));
            return Flowable.fromIterable((Iterable)keys).flatMapCompletable(key -> {
                String path = String.format("%s/%s", target, key.string().substring(prefix.length()));
                ZipEntry entry = new ZipEntry(path);
                out.putNextEntry(entry);
                return this.storage.value(key).flatMapPublisher(content -> content).flatMapCompletable(buffer -> {
                    byte[] content = new byte[buffer.remaining()];
                    buffer.get(content);
                    out.write(content);
                    return Completable.complete();
                }).doOnTerminate(out::closeEntry);
            }, false, 1).doOnTerminate(out::close);
        }).andThen((SingleSource)Single.just((Object)zip));
    }
}

