/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http;

import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.LatestSlice;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rt.RtRule;
import com.artipie.http.rt.SliceRoute;
import com.artipie.http.slice.LoggingSlice;
import com.artipie.http.slice.SliceDownload;
import com.artipie.http.slice.SliceSimple;
import com.artipie.http.slice.SliceWithHeaders;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class GoSlice
implements Slice {
    private static final String TEXT_PLAIN = "text/plain";
    private final Slice origin;

    public GoSlice(Storage storage) {
        this.origin = new SliceRoute(new SliceRoute.Path[]{GoSlice.pathGet(".+/@v/v.*\\.info", GoSlice.createSlice(storage, "application/json")), GoSlice.pathGet(".+/@v/v.*\\.mod", GoSlice.createSlice(storage, TEXT_PLAIN)), GoSlice.pathGet(".+/@v/v.*\\.zip", GoSlice.createSlice(storage, "application/zip")), GoSlice.pathGet(".+/@v/list", GoSlice.createSlice(storage, TEXT_PLAIN)), GoSlice.pathGet(".+/@latest", new LatestSlice(storage)), new SliceRoute.Path(RtRule.FALLBACK, (Slice)new SliceSimple((Response)new RsWithStatus(RsStatus.NOT_FOUND)))});
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.origin.response(line, headers, body);
    }

    private static Slice createSlice(Storage storage, String type) {
        return new SliceWithHeaders((Slice)new SliceDownload(storage), (Headers)new Headers.From("content-type", type));
    }

    private static SliceRoute.Path pathGet(String pattern, Slice slice) {
        return new SliceRoute.Path((RtRule)new RtRule.Multiple(new RtRule[]{new RtRule.ByPath(Pattern.compile(pattern)), new RtRule.ByMethod(RqMethod.GET)}), (Slice)new LoggingSlice(slice));
    }
}

