/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class LatestSlice
implements Slice {
    private final Storage storage;

    public LatestSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(CompletableFuture.supplyAsync(() -> LatestSlice.normalized(line)).thenCompose(path -> this.storage.list((Key)new KeyFromPath(path)).thenCompose(this::resp)));
    }

    private static String normalized(String line) {
        URI received = new RequestLineFrom(line).uri();
        String path = received.getPath();
        String latest = "latest";
        if (path.endsWith("latest")) {
            path = path.substring(0, path.lastIndexOf("latest")).concat("v");
        }
        return path;
    }

    private CompletableFuture<Response> resp(Collection<Key> module) {
        Optional<String> info = module.stream().map(Key::string).filter(item -> item.endsWith("info")).max(Comparator.naturalOrder());
        CompletionStage<Object> res = info.isPresent() ? ((CompletableFuture)((CompletableFuture)this.storage.value((Key)new KeyFromPath(info.get())).thenApply(RsWithBody::new)).thenApply(rsp -> new RsWithHeaders((Response)rsp, "content-type", "application/json"))).thenApply(rsp -> new RsWithStatus((Response)rsp, RsStatus.OK)) : CompletableFuture.completedFuture(StandardRs.NOT_FOUND);
        return res;
    }
}

