/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.helm.IndexYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class PushChartSlice
implements Slice {
    private final Storage storage;
    private final String base;

    public PushChartSlice(Storage storage, String base) {
        this.storage = storage;
        this.base = base;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(this.response(body));
    }

    static byte[] bufsToByteArr(List<ByteBuffer> bufs) {
        Integer size = bufs.stream().map(Buffer::remaining).reduce(Integer::sum).orElse(0);
        byte[] bytes = new byte[size.intValue()];
        int pos = 0;
        for (ByteBuffer buf : bufs) {
            byte[] tocopy = new Remaining(buf).bytes();
            System.arraycopy(tocopy, 0, bytes, pos, tocopy.length);
            pos += tocopy.length;
        }
        return bytes;
    }

    private Single<Response> response(Publisher<ByteBuffer> body) {
        return PushChartSlice.memory(body).flatMapCompletable(arch -> arch.save(this.storage).flatMapCompletable(key -> new IndexYaml(this.storage, this.base).update((TgzArchive)arch))).andThen((SingleSource)Single.just((Object)new RsWithStatus((Response)StandardRs.EMPTY, RsStatus.OK)));
    }

    private static Single<TgzArchive> memory(Publisher<ByteBuffer> body) {
        return Flowable.fromPublisher(body).toList().map(bufs -> new TgzArchive(PushChartSlice.bufsToByteArr(bufs)));
    }
}

