/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.helm.ChartYaml;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.reactivestreams.Subscriber;

final class TgzArchive
implements Content {
    private static final int EIGHT_KB = 8192;
    private final byte[] content;

    TgzArchive(byte[] content) {
        this.content = content;
    }

    public String digest() {
        return DigestUtils.sha256Hex((byte[])this.content);
    }

    public String name() {
        ChartYaml chart = this.chartYaml();
        return String.format("%s-%s.tgz", chart.field("name"), chart.field("version"));
    }

    public ChartYaml chartYaml() {
        return new ChartYaml(this.file("Chart.yaml"));
    }

    public Single<Key> save(Storage storage) {
        Key.From key = new Key.From(this.name());
        return new RxStorageWrapper(storage).save((Key)key, (Content)this).andThen((SingleSource)Single.just((Object)key));
    }

    public Optional<Long> size() {
        return Optional.of(this.content.length).map(Integer::longValue);
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        int resid = this.content.length % 8192;
        int last = resid == 0 ? 0 : 1;
        int chunks = this.content.length / 8192 + last;
        ArrayList<ByteBuffer> arr = new ArrayList<ByteBuffer>(chunks);
        for (int idx = 0; idx < chunks; ++idx) {
            int len = idx == chunks - 1 && last == 1 ? resid : 8192;
            arr.add(ByteBuffer.wrap(this.content, idx * 8192, len));
        }
        Flowable.fromIterable(arr).subscribe(subscriber);
    }

    private String file(String name) {
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream taris = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(this.content)));
            while ((entry = taris.getNextTarEntry()) != null) {
                if (!entry.getName().endsWith(name)) continue;
                return new BufferedReader(new InputStreamReader((InputStream)taris)).lines().collect(Collectors.joining("\n"));
            }
            throw new IllegalStateException(String.format("'%s' file wasn't found", name));
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }
}

