/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

final class IndexYaml {
    private static final Key INDEX_YAML = new Key.From("index.yaml");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.nnnnnnnnnZZZZZ");
    private final Storage storage;
    private final String base;

    IndexYaml(Storage storage, String base) {
        this.storage = storage;
        this.base = base;
    }

    public Completable update(TgzArchive arch) {
        RxStorageWrapper rxs = new RxStorageWrapper(this.storage);
        return rxs.exists(INDEX_YAML).flatMap(arg_0 -> IndexYaml.lambda$update$3((RxStorage)rxs, arg_0)).map(idx -> {
            this.update((Map<String, Object>)idx, arch);
            return idx;
        }).flatMapCompletable(arg_0 -> IndexYaml.lambda$update$5((RxStorage)rxs, arg_0));
    }

    private static Map<String, Object> empty() {
        HashMap<String, Object> res = new HashMap<String, Object>(3);
        res.put("apiVersion", "v1");
        res.put("entries", new HashMap(0));
        res.put("generated", ZonedDateTime.now().format(TIME_FORMATTER));
        return res;
    }

    private void update(Map<String, Object> index, TgzArchive tgz) {
        ArrayList versions;
        String name;
        ChartYaml chart = tgz.chartYaml();
        String version = "version";
        Map entries = (Map)index.get("entries");
        if (!entries.containsKey(name = (String)chart.field("name"))) {
            entries.put(name, new ArrayList(0));
        }
        if ((versions = (ArrayList)entries.get(name)).stream().noneMatch(map -> map.get("version").equals(chart.field("version")))) {
            HashMap<String, Object> newver = new HashMap<String, Object>();
            newver.put("created", ZonedDateTime.now().format(TIME_FORMATTER));
            newver.put("urls", new ArrayList<String>(Collections.singleton(String.format("%s%s", this.base, tgz.name()))));
            newver.put("digest", tgz.digest());
            newver.putAll(chart.fields());
            versions.add(newver);
        }
    }

    private static /* synthetic */ CompletableSource lambda$update$5(RxStorage rxs, Map idx) throws Exception {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        return rxs.save(INDEX_YAML, (Content)new Content.From(new Yaml(options).dump((Object)idx).getBytes(StandardCharsets.UTF_8)));
    }

    private static /* synthetic */ SingleSource lambda$update$3(RxStorage rxs, Boolean exist) throws Exception {
        Single result = exist != false ? rxs.value(INDEX_YAML).flatMap(content -> new Concatenation((Publisher)content).single()).map(buf -> new String(new Remaining(buf).bytes())).map(content -> (Map)new Yaml().load(content)) : Single.just(IndexYaml.empty());
        return result;
    }
}

