/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.helm.metadata.Index;
import com.artipie.helm.metadata.IndexYamlMapping;
import com.artipie.helm.metadata.ParsedChartName;
import com.artipie.helm.metadata.YamlWriter;
import com.artipie.helm.misc.DateTimeNow;
import com.artipie.helm.misc.EmptyIndex;
import com.artipie.helm.misc.LineWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

interface AddWriter {
    public CompletionStage<Void> add(Path var1, Path var2, Map<String, Set<Pair<String, ChartYaml>>> var3);

    public CompletionStage<Void> addTrustfully(Path var1, SortedSet<Key> var2);

    public static final class Asto
    implements AddWriter {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Void> add(Path source, Path out, Map<String, Set<Pair<String, ChartYaml>>> pckgs) {
            return new Index.WithBreaks(this.storage).versionsByPackages((Key)new Key.From(source.getFileName().toString())).thenCompose(vrsns -> {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(source, new OpenOption[0])));
                     BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));){
                    String line;
                    boolean entrs = false;
                    String name = null;
                    YamlWriter writer = new YamlWriter(bufw, 2);
                    LineWriter linewrtr = new LineWriter(writer);
                    while ((line = br.readLine()) != null) {
                        String trimmed = line.trim();
                        int lastposspace = Asto.lastPosOfSpaceInBegin(line);
                        if (!entrs) {
                            entrs = trimmed.equals(ENTRS);
                        }
                        if (entrs && new ParsedChartName(line).valid()) {
                            if (name == null) {
                                writer = new YamlWriter(bufw, lastposspace);
                                linewrtr = new LineWriter(writer);
                            }
                            if (lastposspace == writer.indent()) {
                                Asto.writeRemainedVersionsOfChart(name, pckgs, writer);
                                name = trimmed.replace(":", "");
                            }
                        }
                        if (entrs) {
                            Asto.throwIfVersionExists(trimmed, name, pckgs);
                        }
                        if (entrs && name != null && lastposspace == 0) {
                            Asto.writeRemainedVersionsOfChart(name, pckgs, writer);
                            Asto.writeRemainedChartsAfterCopyIndex(pckgs, writer);
                            entrs = false;
                        }
                        linewrtr.writeAndReplaceTagGenerated(line);
                    }
                    if (entrs) {
                        Asto.writeRemainedChartsAfterCopyIndex(pckgs, writer);
                    }
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
                return CompletableFuture.allOf(new CompletableFuture[0]);
            });
        }

        @Override
        public CompletionStage<Void> addTrustfully(Path out, SortedSet<Key> charts) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    String[] lines;
                    BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));
                    YamlWriter writer = new YamlWriter(bufw, 2);
                    for (String line : lines = new EmptyIndex().asString().split("\n")) {
                        if (line.isEmpty()) continue;
                        writer.writeLine(line, 0);
                    }
                    CompletableFuture result = new CompletableFuture();
                    this.writeChartsToIndex(charts, writer).handle((noth, thr) -> {
                        if (thr == null) {
                            result.complete(null);
                        } else {
                            result.completeExceptionally((Throwable)thr);
                        }
                        try {
                            bufw.close();
                        }
                        catch (IOException exc) {
                            throw new ArtipieIOException(exc);
                        }
                        return null;
                    });
                    return result;
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            }).thenCompose(Function.identity());
        }

        private CompletableFuture<Void> writeChartsToIndex(SortedSet<Key> charts, YamlWriter writer) {
            AtomicReference prev = new AtomicReference();
            CompletionStage<Void> future = CompletableFuture.allOf(new CompletableFuture[0]);
            for (Key key : charts) {
                future = future.thenCompose(noth -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(TgzArchive::new)).thenAccept(tgz -> {
                    HashMap<String, Object> fields = new HashMap<String, Object>(tgz.chartYaml().fields());
                    fields.putAll(tgz.metadata(Optional.empty()));
                    fields.put("created", new DateTimeNow().asString());
                    String name = (String)fields.get("name");
                    try {
                        String[] splitted;
                        if (!name.equals(prev.get())) {
                            writer.writeLine(String.format("%s:", name), 1);
                        }
                        prev.set(name);
                        writer.writeLine("-", 1);
                        for (String line : splitted = new ChartYaml(fields).toString().split("\n")) {
                            writer.writeLine(line, 2);
                        }
                    }
                    catch (IOException exc) {
                        throw new ArtipieIOException(exc);
                    }
                }));
            }
            return future;
        }

        private static void throwIfVersionExists(String trimmed, String name, Map<String, Set<Pair<String, ChartYaml>>> pckgs) {
            if (trimmed.startsWith(VRSNS)) {
                String vers = trimmed.replace(VRSNS, "").trim();
                if (pckgs.containsKey(name) && pckgs.get(name).stream().anyMatch(pair -> ((String)pair.getLeft()).equals(vers))) {
                    throw new IllegalStateException(String.format("Failed to write to index `%s` with version `%s`", name, vers));
                }
            }
        }

        private static void writeRemainedVersionsOfChart(String name, Map<String, Set<Pair<String, ChartYaml>>> pckgs, YamlWriter writer) throws IOException {
            if (name != null && pckgs.containsKey(name)) {
                for (Pair<String, ChartYaml> pair : pckgs.get(name)) {
                    writer.writeLine("-", 2);
                    String str = new IndexYamlMapping(((ChartYaml)pair.getRight()).fields()).toString();
                    for (String entry : str.split("[\\n\\r]+")) {
                        writer.writeLine(entry, 3);
                    }
                }
                pckgs.remove(name);
            }
        }

        private static void writeRemainedChartsAfterCopyIndex(Map<String, Set<Pair<String, ChartYaml>>> pckgs, YamlWriter writer) {
            pckgs.forEach((chart, pairs) -> {
                try {
                    writer.writeLine(String.format("%s:", chart), 1);
                    for (Pair pair : pairs) {
                        String[] lines;
                        writer.writeLine("- ", 2);
                        String yaml = new IndexYamlMapping(((ChartYaml)pair.getRight()).fields()).toString();
                        for (String line : lines = yaml.split("[\\n\\r]+")) {
                            writer.writeLine(line, 3);
                        }
                    }
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            });
            pckgs.clear();
        }

        private static int lastPosOfSpaceInBegin(String line) {
            return line.length() - line.replaceAll("^\\s*", "").length();
        }
    }
}

