/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.metadata;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.helm.metadata.ParsedChartName;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.FileUtils;

public interface Index {
    public CompletionStage<Map<String, Set<String>>> versionsByPackages(Key var1);

    public static final class WithBreaks
    implements Index {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        public WithBreaks(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Map<String, Set<String>>> versionsByPackages(Key idx) {
            return this.storage.exists(idx).thenCompose(exists -> {
                Object res;
                if (exists.booleanValue()) {
                    try {
                        String prefix = "index-";
                        Path tmp = Files.createTempDirectory("index-", new FileAttribute[0]);
                        Path file = Files.createTempFile(tmp, "index-", ".yaml", new FileAttribute[0]);
                        res = ((CompletableFuture)((CompletableFuture)this.storage.value(idx).thenCompose(cont -> new FileStorage(tmp).save((Key)new Key.From(file.getFileName().toString()), cont))).thenApply(ignore -> WithBreaks.versionsByPckgs(file))).thenApply(pckgs -> {
                            FileUtils.deleteQuietly((File)tmp.toFile());
                            return pckgs;
                        });
                    }
                    catch (IOException exc) {
                        res = new FailedCompletionStage((Throwable)exc);
                    }
                } else {
                    res = CompletableFuture.completedFuture(new HashMap());
                }
                return res;
            });
        }

        private static int lastPosOfSpaceInBegin(String line) {
            return line.length() - line.replaceAll("^\\s*", "").length();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Map<String, Set<String>> versionsByPckgs(Path file) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file, new OpenOption[0])));){
                String line;
                boolean entrs = false;
                String name = null;
                int indent = 2;
                HashMap<String, Set<String>> vrns = new HashMap<String, Set<String>>();
                while ((line = br.readLine()) != null) {
                    String trimmed = line.trim();
                    if (!entrs) {
                        entrs = trimmed.equals(ENTRS);
                    }
                    if (new ParsedChartName(line).valid()) {
                        if (name == null) {
                            indent = WithBreaks.lastPosOfSpaceInBegin(line);
                        }
                        if (WithBreaks.lastPosOfSpaceInBegin(line) == indent) {
                            name = trimmed.replace(":", "");
                            vrns.put(name, new HashSet());
                        }
                    }
                    if (!entrs || !trimmed.startsWith(VRSNS)) continue;
                    ((Set)vrns.get(name)).add(line.replace(VRSNS, "").trim());
                }
                HashMap<String, Set<String>> hashMap = vrns;
                return hashMap;
            }
            catch (IOException exc) {
                throw new ArtipieIOException(exc);
            }
        }
    }
}

