/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.helm.metadata.Index;
import com.artipie.helm.metadata.ParsedChartName;
import com.artipie.helm.metadata.YamlWriter;
import com.artipie.helm.misc.EmptyIndex;
import com.artipie.helm.misc.SpaceInBeginning;
import com.artipie.http.misc.TokenizerFlatProc;
import hu.akarnokd.rxjava2.interop.FlowableInterop;
import io.reactivex.Flowable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface RemoveWriter {
    public CompletionStage<Void> delete(Key var1, Path var2, Map<String, Set<String>> var3);

    public static final class Asto
    implements RemoveWriter {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Void> delete(Key source, Path out, Map<String, Set<String>> todelete) {
            return new Index.WithBreaks(this.storage).versionsByPackages(source).thenCompose(fromidx -> {
                Asto.checkExistenceChartsToDelete(fromidx, todelete);
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }).thenCompose(noth -> {
                try {
                    BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));
                    TokenizerFlatProc target = new TokenizerFlatProc("\n");
                    return this.contentOfIndex(source).thenAccept(cont -> cont.subscribe((Subscriber)target)).thenCompose(none -> ((CompletionStage)Flowable.fromPublisher((Publisher)target).map(buf -> new String(new Remaining(buf).bytes())).scan((Object)new ScanContext(bufw, 2), (ctx, curr) -> {
                        String trimmed = curr.trim();
                        int pos = new SpaceInBeginning((String)curr).last();
                        if (!((ScanContext)ctx).inentries) {
                            ((ScanContext)ctx).setEntries(trimmed.equals(ENTRS));
                        }
                        if (((ScanContext)ctx).inentries && new ParsedChartName((String)curr).valid()) {
                            if (((ScanContext)ctx).name.isEmpty()) {
                                ((ScanContext)ctx).setWriter(new YamlWriter(bufw, pos));
                            }
                            if (pos == ((ScanContext)ctx).wrtr.indent()) {
                                if (!((ScanContext)ctx).name.isEmpty()) {
                                    Asto.writeIfNotContainInDeleted(((ScanContext)ctx).lines, todelete, ((ScanContext)ctx).wrtr);
                                }
                                ((ScanContext)ctx).setName(trimmed.replace(":", ""));
                            }
                        }
                        if (((ScanContext)ctx).inentries && !((ScanContext)ctx).name.isEmpty() && pos == 0) {
                            ((ScanContext)ctx).setEntries(false);
                            Asto.writeIfNotContainInDeleted(((ScanContext)ctx).lines, todelete, ((ScanContext)ctx).wrtr);
                        }
                        if (((ScanContext)ctx).inentries && !((ScanContext)ctx).name.isEmpty()) {
                            ((ScanContext)ctx).addLine(curr);
                        }
                        if (((ScanContext)ctx).lines.isEmpty()) {
                            ((ScanContext)ctx).wrtr.writeAndReplaceTagGenerated((String)curr);
                        }
                        return ctx;
                    }).to(FlowableInterop.last())).thenCompose(ctx -> {
                        try {
                            bufw.close();
                        }
                        catch (IOException exc) {
                            throw new ArtipieIOException(exc);
                        }
                        return CompletableFuture.allOf(new CompletableFuture[0]);
                    }));
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            });
        }

        private CompletionStage<Content> contentOfIndex(Key source) {
            return this.storage.exists(source).thenCompose(exists -> {
                CompletableFuture<Content> res = exists != false ? this.storage.value(source) : CompletableFuture.completedFuture(new EmptyIndex().asContent());
                return res;
            });
        }

        private static void writeIfNotContainInDeleted(List<String> lines, Map<String, Set<String>> pckgs, YamlWriter writer) throws IOException {
            ChartVersions items = new ChartVersions(lines);
            String name = items.name().trim().replace(":", "");
            Map<String, List<String>> vrsns = items.versions();
            boolean recordedname = false;
            if (pckgs.containsKey(name)) {
                for (String vers : vrsns.keySet()) {
                    if (pckgs.get(name).contains(vers)) continue;
                    if (!recordedname) {
                        recordedname = true;
                        writer.writeLine(items.name(), 0);
                    }
                    List<String> entry = vrsns.get(vers);
                    for (String line : entry) {
                        writer.writeLine(line, 0);
                    }
                }
            } else {
                for (String line : lines) {
                    writer.writeLine(line, 0);
                }
            }
            lines.clear();
        }

        private static void checkExistenceChartsToDelete(Map<String, Set<String>> fromidx, Map<String, Set<String>> todelete) {
            for (String pckg : todelete.keySet()) {
                if (!fromidx.containsKey(pckg)) {
                    throw new ArtipieException((Throwable)new IllegalStateException(String.format("Failed to delete package `%s` as it is absent in index", pckg)));
                }
                for (String vrsn : todelete.get(pckg)) {
                    if (fromidx.get(pckg).contains(vrsn)) continue;
                    throw new ArtipieException((Throwable)new IllegalStateException(String.format("Failed to delete package `%s` with version `%s` as it is absent in index", pckg, vrsn)));
                }
            }
        }

        private static final class ScanContext {
            private boolean inentries;
            private YamlWriter wrtr;
            private String name;
            private final List<String> lines;

            ScanContext(BufferedWriter bufw, int indent) {
                this.wrtr = new YamlWriter(bufw, indent);
                this.name = "";
                this.lines = new ArrayList<String>(2);
            }

            private void setEntries(boolean inentrs) {
                this.inentries = inentrs;
            }

            private void setName(String cname) {
                this.name = cname;
            }

            private void setWriter(YamlWriter writer) {
                this.wrtr = writer;
            }

            private void addLine(String line) {
                this.lines.add(line);
            }
        }

        private static final class ChartVersions {
            private final List<String> lines;

            ChartVersions(List<String> lines) {
                this.lines = lines;
            }

            public Map<String, List<String>> versions() {
                HashMap<String, List<String>> vrsns = new HashMap<String, List<String>>();
                int dash = 45;
                if (this.lines.size() > 1) {
                    int indent = this.lines.get(1).indexOf(45);
                    ArrayList<String> tmp = new ArrayList<String>(2);
                    for (int idx = 1; idx < this.lines.size(); ++idx) {
                        if (this.lines.get(idx).charAt(indent) == '-' && !tmp.isEmpty()) {
                            vrsns.put(ChartVersions.version(tmp), new ArrayList<String>(tmp));
                            tmp.clear();
                        }
                        tmp.add(this.lines.get(idx));
                    }
                    vrsns.put(ChartVersions.version(tmp), new ArrayList<String>(tmp));
                }
                return vrsns;
            }

            public String name() {
                if (!this.lines.isEmpty()) {
                    return this.lines.get(0);
                }
                throw new IllegalStateException("Failed to get name as there are no lines");
            }

            private static String version(List<String> entry) {
                return entry.stream().filter(line -> line.trim().startsWith(Asto.VRSNS)).map(line -> line.replace(Asto.VRSNS, "")).map(String::trim).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find version for deletion"));
            }
        }
    }
}

